local cockpit = folder.."../../../Cockpit/Scripts/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")

join(res.keyCommands,{

{combos = {{key = 'Home',  reformers = {'LWin'}}},			down = iCommandEnginesStart, name = _('Auto Start'),	category = _('Cheat')},
{combos = {{key = 'End' ,  reformers = {'LWin'}}},			down = iCommandEnginesStop,  name = _('Auto Stop') ,	category = _('Cheat')},
{combos = {{key = 'R', reformers = {'LCtrl','LShift'}}},	down = device_commands.Button_1, cockpit_device_id = 0, value_down = 1.0, name = _('Recorder On'), category = _('Cheat')},
{combos = {{key = 'R', reformers = {'LAlt','LShift'}}},		down = device_commands.Button_2, cockpit_device_id = 0, value_down = 1.0, name = _('Recorder Off'), category = _('Cheat')},

-- General
{combos = {{key = 'P', reformers = {'RShift'}}}, 			down = iCommandCockpitShowPilotOnOff, name = _('Show pilot body'), category = _('General')},

-- Flight Control
{combos = {{key = 'Up'}},	 down = iCommandPlaneUpStart,			up = iCommandPlaneUpStop,			name = _('Aircraft Down'),			category = _('Flight Control')},
{combos = {{key = 'Down'}},	 down = iCommandPlaneDownStart,			up = iCommandPlaneDownStop,			name = _('Aircraft Up'),			category = _('Flight Control')},
{combos = {{key = 'Left'}},	 down = iCommandPlaneLeftStart,			up = iCommandPlaneLeftStop,			name = _('Aircraft Bank Left'),		category = _('Flight Control')},
{combos = {{key = 'Right'}}, down = iCommandPlaneRightStart,		up = iCommandPlaneRightStop,		name = _('Aircraft Bank Right'),	category = _('Flight Control')},
{combos = {{key = 'Z'}},	 down = iCommandPlaneLeftRudderStart,	up = iCommandPlaneLeftRudderStop,	name = _('Aircraft Rudder Left'),	category = _('Flight Control')},
{combos = {{key = 'X'}},	 down = iCommandPlaneRightRudderStart,	up = iCommandPlaneRightRudderStop,	name = _('Aircraft Rudder Right'),	category = _('Flight Control')},

{combos = {{key = '.', reformers = {'RCtrl'}}}, down = iCommandPlaneTrimUp,		up = iCommandPlaneTrimUp,	 value_down = 1, value_up = 0, name = _('Elevator Trimmer Switch, PULL(CLIMB)'),	category = _('Flight Control')},
{combos = {{key = ';', reformers = {'RCtrl'}}}, down = iCommandPlaneTrimDown,	up = iCommandPlaneTrimDown,	 value_down = 1, value_up = 0, name = _('Elevator Trimmer Switch, PUSH(DESCEND)'),	category = _('Flight Control')},
{combos = {{key = ',', reformers = {'RCtrl'}}}, down = iCommandPlaneTrimLeft,	up = iCommandPlaneTrimLeft,	 value_down = 1, value_up = 0, name = _('Aileron Trimmer Switch, LEFT'),			category = _('Flight Control')},
{combos = {{key = '/', reformers = {'RCtrl'}}}, down = iCommandPlaneTrimRight,	up = iCommandPlaneTrimRight, value_down = 1, value_up = 0, name = _('Aileron Trimmer Switch, RIGHT'),			category = _('Flight Control')},

{combos = {{key = 'Num+'}},		pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  name = _('Thrust Smoothly Up'),		category = _('Flight Control')},
{combos = {{key = 'Num-'}},		pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  name = _('Thrust Smoothly Down'),	category = _('Flight Control')},

{combos = {{key = 'PageUp'}},	down = iCommandPlaneAUTIncreaseRegime, name = _('Thrust Step Up'),	 category = _('Flight Control')},
{combos = {{key = 'PageDown'}}, down = iCommandPlaneAUTDecreaseRegime, name = _('Thrust Step Down'), category = _('Flight Control')},

-- Systems
{combos = {{key = 'B'}},						 	down = iCommandPlaneAirBrake,		up = iCommandPlaneAirBrake,		value_down = 1,	value_up = 0,	name = _('Airbrake Button, Hold to extend'),	category = _('Systems')},
{combos = {{key = 'B', reformers = {'LShift'}}},	down = iCommandPlaneAirBrakeOn,		up = iCommandPlaneAirBrakeOn,	value_down = 1,	value_up = 0,	name = _('Airbrake Switch, OPEN'),				category = _('Systems')},
{combos = {{key = 'B', reformers = {'LCtrl'}}},		down = iCommandPlaneAirBrakeOff,	up = iCommandPlaneAirBrakeOff, 	value_down = 1,	value_up = 0,	name = _('Airbrake Switch, CLOSE'),				category = _('Systems')},
{combos = {{key = 'F'}},							down = iCommandPlaneFlaps,																			name = _('Wing Flaps Handle, Up/Down'),			category = _('Systems')},
{combos = {{key = 'F', reformers = {'LShift'}}},	down = iCommandPlaneFlapsOn,																		name = _('Wing Flaps Handle, Down'),			category = _('Systems')},
{combos = {{key = 'F', reformers = {'LCtrl'}}},		down = iCommandPlaneFlapsOff,																		name = _('Wing Flaps Handle, Up'),				category = _('Systems')},
{combos = {{key = 'G'}},							down = iCommandPlaneGear,																			name = _('Landing Gear Handle, Up/Down'),		category = _('Systems')},
{combos = {{key = 'G', reformers = {'LCtrl'}}},		down = iCommandPlaneGearUp,																			name = _('Landing Gear Handle, Up'),			category = _('Systems')},
{combos = {{key = 'G', reformers = {'LShift'}}},	down = iCommandPlaneGearDown,																		name = _('Landing Gear Handle, Down'),			category = _('Systems')},
{combos = {{key = 'W'}},							down = iCommandPlaneWheelBrakeOn,			up = iCommandPlaneWheelBrakeOff,						name = _('Wheel Brake On'),						category = _('Systems')},
{combos = {{key = 'W', reformers = {'LShift'}}},	down = iCommandPlaneWheelBrakeRightOn,		up = iCommandPlaneWheelBrakeOff,						name = _('Forced Wheel Brake On'),				category = _('Systems')},
{combos = {{key = 'C', reformers = {'LCtrl'}}},		down = iCommandPlaneFonar, 																			name = _('Canopy Open/Close'),					category = _('Systems')},
{combos = {{key = 'E', reformers = {'LCtrl'}}},		down = iCommandPlaneEject,																			name = _('Eject (3 times)'),					category = _('Systems')},

{combos = {{key = 'Space', reformers = {'RAlt'}}},		down = iCommandPlanePickleOn,				up = iCommandPlanePickleOff,																								name = _('Weapon Release Button'),							category = {_('Stick')}},
{combos = {{key = 'Space', reformers = {'RCtrl'}}},		down = weapons_commands.TrgFirstDetent,		up = weapons_commands.TrgFirstDetent,		cockpit_device_id = devices.WEAPONS_CONTROL,	value_down =  1, value_up = 0,	name = _('Gun Trigger - FIRST DETENT'), 					category = {_('Stick')}},
{combos = {{key = 'Space'}},							down = iCommandPlaneFire,					up = iCommandPlaneFireOff, 																									name = _('Gun Trigger - SECOND DETENT (Press to shoot)'),	category = {_('Stick')}},

{combos = {{key = 'D'}},	down = iCommandPlaneChangeWeapon,	name = _('Cycle Weapon'),	category = _('Weapons')},


--{combos = {{key = 'T'}},							down = iCommandPlaneWingtipSmokeOnOff,		name = _('Smoke'),						category = _('Systems')},
--{combos = {{key = 'W', reformers = {'LCtrl'}}},		down = iCommandPlaneJettisonWeapons,	up = iCommandPlaneJettisonWeaponsUp, name = _('Weapons Jettison'),		category = _('Systems')},
--{combos = {{key = 'R', reformers = {'LAlt'}}},		down = iCommandPlaneJettisonFuelTanks, up   = iCommandPlaneJettisonFuelTanksUp, name = _('Jettison Fuel Tanks'), category = _('Systems')},

--{combos = {{key = 'N', reformers = {'RAlt'}}}, down = iCommandViewLeftMirrorOn ,	up = iCommandViewLeftMirrorOff , name = _('Mirror Left On'), category = _('View Cockpit')},
--{combos = {{key = 'M', reformers = {'RAlt'}}}, down = iCommandViewRightMirrorOn,	up = iCommandViewRightMirrorOff, name = _('Mirror Right On'), category = _('View Cockpit')},
--{combos = {{key = 'M' }}, down = iCommandToggleMirrors, name = _('Toggle Mirrors'), category = _('View Cockpit')},

-- 
--{down = electric_commands.F5_Command_BatterySw_EXT,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('Battery Switch, Batt/Off'),			category = _('Right Vertical Panel')},
--{down = electric_commands.F5_Command_LeftGeneratorSw_EXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('Left Generator Switch, On/Off'),	category = _('Right Vertical Panel')},
--{down = electric_commands.F5_Command_LeftGeneratorSw_EXT,	up = electric_commands.F5_Command_LeftGeneratorSw_EXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	value_up = 0,	name = _('Left Generator Switch, Reset'),	category = _('Right Vertical Panel')},
--{down = electric_commands.F5_Command_RightGeneratorSw_EXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('Right Generator Switch, On/Off'),	category = _('Right Vertical Panel')},
--{down = electric_commands.F5_Command_RightGeneratorSw_EXT,	up = electric_commands.F5_Command_LeftGeneratorSw_EXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	value_up = 0,	name = _('Right Generator Switch, Reset'),	category = _('Right Vertical Panel')},

})
return res
